/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.crafter;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.crafter.ContainerCrafter;
import com.lothrazar.cyclic.capabilities.CustomEnergyStorage;
import com.lothrazar.cyclic.capabilities.ItemStackHandlerWrapper;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileCrafter
extends TileBlockEntityCyclic
implements MenuProvider {
    static final int MAX = 64000;
    public static final int TIMER_FULL = 40;
    public static ForgeConfigSpec.IntValue POWERCONF;
    private CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    ItemStackHandler inputHandler = new ItemStackHandler(10);
    ItemStackHandler outHandler = new ItemStackHandler(10);
    private final LazyOptional<IItemHandler> input = LazyOptional.of(() -> this.inputHandler);
    private final LazyOptional<IItemHandler> output = LazyOptional.of(() -> this.outHandler);
    private final LazyOptional<IItemHandler> gridCap = LazyOptional.of(() -> new ItemStackHandler(9));
    private final LazyOptional<IItemHandler> preview = LazyOptional.of(() -> new ItemStackHandler(1));
    private ItemStackHandlerWrapper inventoryWrapper = new ItemStackHandlerWrapper(this.inputHandler, this.outHandler);
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventoryWrapper);
    public static final int IO_NUM_ROWS = 5;
    public static final int IO_NUM_COLS = 2;
    public static final int GRID_NUM_ROWS = 3;
    public static final int GRID_NUM_COLS = 3;
    public static final int IO_SIZE = 10;
    public static final int GRID_SIZE = 9;
    public static final int PREVIEW_SLOT = 29;
    public static final int OUTPUT_SLOT_START = 19;
    public static final int OUTPUT_SLOT_STOP = 28;
    public static final int GRID_SLOT_START = 10;
    public static final int GRID_SLOT_STOP = 18;
    private boolean hasValidRecipe = false;
    public boolean shouldSearch = true;
    private ArrayList<ItemStack> lastRecipeGrid = null;
    private Recipe<?> lastValidRecipe = null;
    private ItemStack recipeOutput = ItemStack.f_41583_;
    private final CraftingContainer craftMatrix = new CraftingContainer((AbstractContainerMenu)new FakeContainer(MenuType.f_39968_, 18291238), 3, 3);

    public TileCrafter(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.CRAFTER.get(), pos, state);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index != 29 && (index < 19 || index > 28)) {
            super.m_7013_(index, stack);
        }
        return false;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileCrafter e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileCrafter e) {
        e.tick();
    }

    public void tick() {
        this.syncEnergy();
        if (this.f_58857_ == null || this.f_58857_.m_142572_() == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        IItemHandler previewHandler = (IItemHandler)this.preview.orElse(null);
        ArrayList<ItemStack> itemStacksInGrid = this.getItemsInCraftingGrid();
        if (this.lastRecipeGrid == null) {
            this.lastRecipeGrid = itemStacksInGrid;
        }
        if (itemStacksInGrid == null || this.countNonEmptyStacks(itemStacksInGrid) == 0) {
            this.setPreviewSlot(previewHandler, ItemStack.f_41583_);
            this.timer = 40;
            return;
        }
        if (!itemStacksInGrid.equals(this.lastRecipeGrid)) {
            this.reset();
            this.lastRecipeGrid = itemStacksInGrid;
            this.shouldSearch = true;
        }
        if (!this.hasValidRecipe && this.shouldSearch) {
            Recipe<?> recipe = this.tryRecipes(itemStacksInGrid);
            if (recipe != null) {
                this.hasValidRecipe = true;
                this.lastValidRecipe = recipe;
                this.lastRecipeGrid = itemStacksInGrid;
                this.recipeOutput = this.lastValidRecipe.m_8043_();
                this.shouldSearch = false;
                this.setPreviewSlot(previewHandler, this.lastValidRecipe.m_8043_());
                this.timer = 40;
            } else {
                this.reset();
                this.shouldSearch = false;
            }
        }
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        IEnergyStorage cap = (IEnergyStorage)this.energyCap.orElse(null);
        if (cap == null) {
            return;
        }
        int cost = (Integer)POWERCONF.get();
        if (cap.getEnergyStored() < cost && cost > 0) {
            return;
        }
        if (this.hasValidRecipe) {
            if (--this.timer > 0) {
                return;
            }
            this.timer = 40;
            if (this.doCraft((IItemHandler)this.inputHandler, true)) {
                ItemStack output = this.recipeOutput.m_41777_();
                if (this.hasFreeSpace((IItemHandler)this.outHandler, this.recipeOutput) && this.doCraft((IItemHandler)this.inputHandler, false)) {
                    if (this.lastValidRecipe != null && this.lastValidRecipe instanceof ShapedRecipe) {
                        ShapedRecipe r = (ShapedRecipe)this.lastValidRecipe;
                        r.m_7457_((Container)this.craftMatrix);
                    }
                    this.energy.extractEnergy(cost, false);
                    for (int i = 0; i < this.craftMatrix.m_6643_(); ++i) {
                        int j;
                        ItemStack result;
                        boolean leftoverEqual;
                        ItemStack recipeLeftover = this.craftMatrix.m_8020_(i);
                        if (recipeLeftover.m_41619_() || recipeLeftover.getContainerItem().m_41619_()) continue;
                        boolean bl = leftoverEqual = recipeLeftover.m_41720_() == recipeLeftover.getContainerItem().m_41720_();
                        if (leftoverEqual) {
                            result = recipeLeftover.getContainerItem().m_41777_();
                            for (j = 0; j < this.inputHandler.getSlots() && !(result = this.inputHandler.insertItem(j, result, false)).m_41619_(); ++j) {
                            }
                            continue;
                        }
                        result = recipeLeftover.getContainerItem().m_41777_();
                        for (j = 0; j < this.outHandler.getSlots() && !(result = this.outHandler.insertItem(j, result, false)).m_41619_(); ++j) {
                        }
                    }
                    for (int slotId = 0; slotId < 10 && (output = this.outHandler.insertItem(slotId, output, false)) != ItemStack.f_41583_ && output.m_41613_() != 0; ++slotId) {
                    }
                }
            }
        }
    }

    private ArrayList<ItemStack> getItemsInCraftingGrid() {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        IItemHandler gridHandler = (IItemHandler)this.gridCap.orElse(null);
        if (gridHandler == null) {
            return null;
        }
        for (int i = 0; i < 9; ++i) {
            itemStacks.add(gridHandler.getStackInSlot(i));
        }
        return itemStacks;
    }

    private void setPreviewSlot(IItemHandler previewHandler, ItemStack itemStack) {
        previewHandler.extractItem(0, 64, false);
        previewHandler.insertItem(0, itemStack, false);
    }

    private boolean hasFreeSpace(IItemHandler inv, ItemStack output) {
        for (int slotId = 0; slotId < 10; ++slotId) {
            if (inv.getStackInSlot(slotId) == ItemStack.f_41583_ || inv.getStackInSlot(slotId).m_41656_(output) && inv.getStackInSlot(slotId).m_41613_() + output.m_41613_() <= output.m_41741_()) {
                return true;
            }
            if (output != ItemStack.f_41583_ && output.m_41613_() != 0) continue;
            return true;
        }
        return false;
    }

    private boolean doCraft(IItemHandler input, boolean simulate) {
        HashMap<Integer, List<ItemStack>> putbackStacks = new HashMap<Integer, List<ItemStack>>();
        for (Ingredient ingredient : this.lastValidRecipe.m_7527_()) {
            if (ingredient == Ingredient.f_43901_) continue;
            boolean matched = false;
            for (int index = 0; index < input.getSlots(); ++index) {
                ItemStack itemStack = input.getStackInSlot(index);
                if (!ingredient.test(itemStack)) continue;
                if (putbackStacks.containsKey(index)) {
                    putbackStacks.get(index).add(new ItemStack((ItemLike)input.getStackInSlot(index).m_41720_(), 1));
                } else {
                    ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                    list.add(new ItemStack((ItemLike)input.getStackInSlot(index).m_41720_(), 1));
                    putbackStacks.put(index, list);
                }
                matched = true;
                input.extractItem(index, 1, false);
                break;
            }
            if (matched) continue;
            this.putbackStacks(putbackStacks, input);
            return false;
        }
        if (simulate) {
            this.putbackStacks(putbackStacks, input);
        }
        return true;
    }

    private void putbackStacks(HashMap<Integer, List<ItemStack>> putbackStacks, IItemHandler itemHandler) {
        for (Map.Entry<Integer, List<ItemStack>> entry : putbackStacks.entrySet()) {
            for (ItemStack stack : entry.getValue()) {
                itemHandler.insertItem(entry.getKey().intValue(), stack, false);
            }
        }
    }

    private Recipe<?> tryRecipes(ArrayList<ItemStack> itemStacksInGrid) {
        if (this.f_58857_ == null || this.f_58857_.m_142572_() == null) {
            return null;
        }
        Collection recipes = this.f_58857_.m_142572_().m_129894_().m_44051_();
        for (Recipe recipe : recipes) {
            ShapedRecipe shapedRecipe;
            if (recipe instanceof ShapelessRecipe) {
                ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
                if (!this.tryMatchShapelessRecipe(itemStacksInGrid, shapelessRecipe)) continue;
                return shapelessRecipe;
            }
            if (!(recipe instanceof ShapedRecipe) || !this.doSizesMatch(shapedRecipe = (ShapedRecipe)recipe, itemStacksInGrid) || !this.tryMatchShapedRecipe(itemStacksInGrid, shapedRecipe)) continue;
            return shapedRecipe;
        }
        return null;
    }

    private boolean tryMatchShapedRecipe(ArrayList<ItemStack> itemStacks, ShapedRecipe recipe) {
        for (int i = 0; i <= 3 - recipe.m_44220_(); ++i) {
            for (int j = 0; j <= 3 - recipe.m_44221_(); ++j) {
                if (!this.tryMatchShapedRecipeRegion(itemStacks, recipe, i, j)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean tryMatchShapelessRecipe(ArrayList<ItemStack> itemStacks, ShapelessRecipe recipe) {
        ArrayList itemStacksCopy = (ArrayList)itemStacks.clone();
        for (Ingredient ingredient : recipe.m_7527_()) {
            Iterator iter = itemStacksCopy.iterator();
            boolean matched = false;
            while (iter.hasNext()) {
                ItemStack itemStack = (ItemStack)iter.next();
                if (!ingredient.test(itemStack)) continue;
                iter.remove();
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return this.countNonEmptyStacks(itemStacksCopy) == 0;
    }

    private boolean tryMatchShapedRecipeRegion(ArrayList<ItemStack> itemStacks, ShapedRecipe recipe, int offsetX, int offsetY) {
        for (int i = 0; i < recipe.m_44220_(); ++i) {
            for (int j = 0; j < recipe.m_44221_(); ++j) {
                try {
                    int indexInArray = i + j * 3;
                    ItemStack itemStack = itemStacks.get(indexInArray);
                    this.craftMatrix.m_6836_(indexInArray, itemStack.m_41777_());
                    continue;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        boolean matched = recipe.m_5818_(this.craftMatrix, this.f_58857_);
        return matched;
    }

    public void reset() {
        this.hasValidRecipe = false;
        this.lastRecipeGrid = null;
        this.lastValidRecipe = null;
        this.shouldSearch = true;
        this.timer = 0;
        IItemHandler previewHandler = (IItemHandler)this.preview.orElse(null);
        if (previewHandler != null) {
            this.setPreviewSlot(previewHandler, ItemStack.f_41583_);
        }
    }

    private int countNonEmptyStacks(ArrayList<ItemStack> itemStacks) {
        int count = 0;
        for (ItemStack itemStack : itemStacks) {
            if (itemStack == ItemStack.f_41583_) continue;
            ++count;
        }
        return count;
    }

    private boolean doSizesMatch(ShapedRecipe recipe, ArrayList<ItemStack> itemStacks) {
        int ingredientCount = 0;
        int itemStackCount = 0;
        for (Ingredient ingredient : recipe.m_7527_()) {
            if (ingredient.test(ItemStack.f_41583_)) continue;
            ++ingredientCount;
        }
        for (ItemStack itemStack : itemStacks) {
            if (itemStack == ItemStack.f_41583_) continue;
            ++itemStackCount;
        }
        return ingredientCount == itemStackCount;
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerCrafter(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, ItemHandlers type) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            switch (type) {
                case INPUT: {
                    return this.input.cast();
                }
                case OUTPUT: {
                    return this.output.cast();
                }
                case GRID: {
                    return this.gridCap.cast();
                }
                case PREVIEW: {
                    return this.preview.cast();
                }
            }
        }
        return null;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.energyCap.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)tag.m_128469_("energy")));
        this.input.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)tag.m_128469_("input")));
        this.output.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)tag.m_128469_("output")));
        this.gridCap.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)tag.m_128469_("grid")));
        this.preview.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)tag.m_128469_("preview")));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        this.energyCap.ifPresent(h -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)h).serializeNBT();
            tag.m_128365_("energy", (Tag)compound);
        });
        this.input.ifPresent(h -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)h).serializeNBT();
            tag.m_128365_("input", (Tag)compound);
        });
        this.output.ifPresent(h -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)h).serializeNBT();
            tag.m_128365_("output", (Tag)compound);
        });
        this.gridCap.ifPresent(h -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)h).serializeNBT();
            tag.m_128365_("grid", (Tag)compound);
        });
        this.preview.ifPresent(h -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)h).serializeNBT();
            tag.m_128365_("preview", (Tag)compound);
        });
        super.m_183515_(tag);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
        }
        return -1;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % 2;
            }
        }
    }

    public static class FakeContainer
    extends AbstractContainerMenu {
        protected FakeContainer(MenuType<?> type, int id) {
            super(type, id);
        }

        public boolean m_6875_(Player playerIn) {
            return true;
        }
    }

    public static enum ItemHandlers {
        INPUT,
        OUTPUT,
        GRID,
        PREVIEW;

    }

    public static enum Fields {
        TIMER,
        REDSTONE,
        RENDER;

    }
}

